// ==========================================================================//
//     (C) Copyright 2007 Agilent Technologies
// ==========================================================================

#include "PCIEFPGAFramework.h"

// -----------------------------------------------------------------------
static CPCIEFpgaFramework *pFpgaFramework = 0;

// --------------------------------------------------------------------------
CPCIEFpgaFramework &CPCIEFpgaFramework::instance( void )
{
  if( pFpgaFramework == NULL )
  {
    AGT_THROW( "CPCIEFpgaFramework: FPGA Framework not instantiated" );
  }
  else
  {
    return *pFpgaFramework;
  }
}

// --------------------------------------------------------------------------
CPCIEFpgaFramework::CPCIEFpgaFramework( void )
{
  if( pFpgaFramework != NULL )
  {
    AGT_THROW( "CPCIEFpgaFramework: FPGA Framework already instantiated" );
  }
  else
  {
    pFpgaFramework = this;
  }
}

// ----------------------------------------------------------------------- 
CPCIEFpgaFramework::~CPCIEFpgaFramework( void )
{
}

// -----------------------------------------------------------------------    
CPCIEFpgaTxMemories& CPCIEFpgaFramework::getFpgaTxMemories( void )
{
  return mFPGATxMemories;
}

// -----------------------------------------------------------------------    
CPCIEFpgaCSPkt& CPCIEFpgaFramework::getFpgaCSPkt( void )
{
  return mFPGACSPkt;
}

// -----------------------------------------------------------------------    
CPCIEConfigSpace& CPCIEFpgaFramework::getConfigSpace( void )
{
  return mPCIEConfigSpace;
}

// -----------------------------------------------------------------------    
CPCIEFpgaCSDat& CPCIEFpgaFramework::getFpgaCSDat( void )
{
  return mFPGACSDat;
}

// -----------------------------------------------------------------------    
CPCIEFpgaCSSpc& CPCIEFpgaFramework::getFpgaCSSpc( void )
{
  return mFPGACSSpc;
}

// ----------------------------------------------------------------------- 
CPCIEFpgaCSMis& CPCIEFpgaFramework::getFpgaCSMis( void )
{
  return mFPGACSMis;
}

// ----------------------------------------------------------------------- 
void CPCIEFpgaFramework::CompleterRun( const AgtPortHandleT& portHandle )
{
  UInt32 uVal = mFPGACSPkt.getTxCtrl( portHandle );

  uVal |= 0x1 << ( ( UInt8 )CPCIEFpgaCSPkt::FPGATXMISC_CTRL_START_COMP_ALL_BIT );

  mFPGACSPkt.setTxCtrl( portHandle, uVal );
}